/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Aromatherapy 
**
** DESCRIPTION:	Aromatherapy Puzzle
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef AROMATHERAPY_H
#define AROMATHERAPY_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwImage.h"
#include "PuzzleInterface.h"
#include "../Collectables/CollectableInterface.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int Aromatherapy_c_iNumBurners = 6;

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CAromatherapy : public IPuzzle, public ICollectable
{
	friend class CPuzzle;

private:

	//class structures
	struct SBurner
	{
		bool	m_bContainsHerbs;
		bool	m_bIsLit;
	};

	struct SSaveState
	{
		SBurner		m_sBurner[Aromatherapy_c_iNumBurners];
	};

	//class data
	SBurner		m_sBurner[Aromatherapy_c_iNumBurners];

	//class methods
	//setup
	public:		CAromatherapy(void);
	public:		void Reset();
	public:		const int LoadState(const unsigned char *pData);
	public:		const int SaveState(const unsigned char *pData, const int iMaxDataSize) const;

	// process
	public:		void Refresh();
	public:		void Draw() const;
	public:		void Draw(const int iRef) const;
	public:		void Advance(CVillager &Villager, const int iBurner);
	public:		void Complete();

	public:		const bool Carry(CVillager &Villager, const ECarrying eCarrying);
	public:		void Drop(CVillager &Villager, const ECarrying eCarrying);

	// access
	public:		const ECarrying GetNearbyCollectable(CVillager &Villager, const ldwPoint sPos);
	public:		const int GetEmptyBurners(int *piEmptyBurners) const;
	public:		const int GetUnlitBurners(int *piUnlitBurners) const;
	public:		const ldwPoint BurnerPos(const int iBurner) const;
	public:		const bool AllBurnersContainHerbs() const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CAromatherapy		Aromatherapy;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/